#ifndef _TABWPINDEX_H
#define _TABWPINDEX_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../SockServer/SockServer.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabWPIndexDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd;
    static HWND SQLDriver_hWnd;
    static HWND SQLDatabase_hWnd;
    static HWND SQLUserName_hWnd;
    static HWND SQLPassword_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        SQLServer_hWnd   = GetDlgItem(xHandle, IDC_SQLSERVER);
        SQLDriver_hWnd   = GetDlgItem(xHandle, IDC_SQLDRIVER);
        SQLDatabase_hWnd = GetDlgItem(xHandle, IDC_SQLDATABASE);
        SQLUserName_hWnd = GetDlgItem(xHandle, IDC_SQLUSERNAME);
        SQLPassword_hWnd = GetDlgItem(xHandle, IDC_SQLPASSWORD);

        /*
		Set_Text(SQLServer_hWnd, gsSQLIndexServer);
        Set_Text(SQLDriver_hWnd, gsSQLIndexDriver);
        Set_Text(SQLDatabase_hWnd, gsSQLIndexDatabase);
        Set_Text(SQLUserName_hWnd, gsSQLIndexUserID);
        Set_Text(SQLPassword_hWnd, gsSQLIndexPassword);
		*/

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
